/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.system;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.SysPost;
import com.ruoyi.system.service.ISysPostService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/post"})
public class SysPostController
extends BaseController {
    private String prefix = "system/post";
    @Autowired
    private ISysPostService postService;

    @RequiresPermissions(value={"system:post:view"})
    @GetMapping
    public String operlog() {
        return this.prefix + "/post";
    }

    @RequiresPermissions(value={"system:post:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(SysPost post) {
        this.startPage();
        List list = this.postService.selectPostList(post);
        return this.getDataTable(list);
    }

    @Log(title="\u5c97\u4f4d\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:post:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(SysPost post) {
        List list = this.postService.selectPostList(post);
        ExcelUtil util = new ExcelUtil(SysPost.class);
        return util.exportExcel(list, "\u5c97\u4f4d\u6570\u636e");
    }

    @RequiresPermissions(value={"system:post:remove"})
    @Log(title="\u5c97\u4f4d\u7ba1\u7406", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        try {
            return this.toAjax(this.postService.deletePostByIds(ids));
        }
        catch (Exception e) {
            return this.error(e.getMessage());
        }
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @RequiresPermissions(value={"system:post:add"})
    @Log(title="\u5c97\u4f4d\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(@Validated SysPost post) {
        if ("1".equals(this.postService.checkPostNameUnique(post))) {
            return this.error("\u65b0\u589e\u5c97\u4f4d'" + post.getPostName() + "'\u5931\u8d25\uff0c\u5c97\u4f4d\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if ("1".equals(this.postService.checkPostCodeUnique(post))) {
            return this.error("\u65b0\u589e\u5c97\u4f4d'" + post.getPostName() + "'\u5931\u8d25\uff0c\u5c97\u4f4d\u7f16\u7801\u5df2\u5b58\u5728");
        }
        post.setCreateBy(this.getLoginName());
        return this.toAjax(this.postService.insertPost(post));
    }

    @GetMapping(value={"/edit/{postId}"})
    public String edit(@PathVariable(value="postId") Long postId, ModelMap mmap) {
        mmap.put((Object)"post", (Object)this.postService.selectPostById(postId));
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"system:post:edit"})
    @Log(title="\u5c97\u4f4d\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated SysPost post) {
        if ("1".equals(this.postService.checkPostNameUnique(post))) {
            return this.error("\u4fee\u6539\u5c97\u4f4d'" + post.getPostName() + "'\u5931\u8d25\uff0c\u5c97\u4f4d\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if ("1".equals(this.postService.checkPostCodeUnique(post))) {
            return this.error("\u4fee\u6539\u5c97\u4f4d'" + post.getPostName() + "'\u5931\u8d25\uff0c\u5c97\u4f4d\u7f16\u7801\u5df2\u5b58\u5728");
        }
        post.setUpdateBy(this.getLoginName());
        return this.toAjax(this.postService.updatePost(post));
    }

    @PostMapping(value={"/checkPostNameUnique"})
    @ResponseBody
    public String checkPostNameUnique(SysPost post) {
        return this.postService.checkPostNameUnique(post);
    }

    @PostMapping(value={"/checkPostCodeUnique"})
    @ResponseBody
    public String checkPostCodeUnique(SysPost post) {
        return this.postService.checkPostCodeUnique(post);
    }
}

