/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.system;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.shiro.util.AuthorizationUtils;
import com.ruoyi.system.domain.SysUserRole;
import com.ruoyi.system.service.ISysRoleService;
import com.ruoyi.system.service.ISysUserService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/role"})
public class SysRoleController
extends BaseController {
    private String prefix = "system/role";
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysUserService userService;

    @RequiresPermissions(value={"system:role:view"})
    @GetMapping
    public String role() {
        return this.prefix + "/role";
    }

    @RequiresPermissions(value={"system:role:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(SysRole role) {
        this.startPage();
        List list = this.roleService.selectRoleList(role);
        return this.getDataTable(list);
    }

    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:role:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(SysRole role) {
        List list = this.roleService.selectRoleList(role);
        ExcelUtil util = new ExcelUtil(SysRole.class);
        return util.exportExcel(list, "\u89d2\u8272\u6570\u636e");
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @RequiresPermissions(value={"system:role:add"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(@Validated SysRole role) {
        if ("1".equals(this.roleService.checkRoleNameUnique(role))) {
            return this.error("\u65b0\u589e\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if ("1".equals(this.roleService.checkRoleKeyUnique(role))) {
            return this.error("\u65b0\u589e\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u6743\u9650\u5df2\u5b58\u5728");
        }
        role.setCreateBy(this.getLoginName());
        AuthorizationUtils.clearAllCachedAuthorizationInfo();
        return this.toAjax(this.roleService.insertRole(role));
    }

    @GetMapping(value={"/edit/{roleId}"})
    public String edit(@PathVariable(value="roleId") Long roleId, ModelMap mmap) {
        mmap.put((Object)"role", (Object)this.roleService.selectRoleById(roleId));
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"system:role:edit"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated SysRole role) {
        this.roleService.checkRoleAllowed(role);
        if ("1".equals(this.roleService.checkRoleNameUnique(role))) {
            return this.error("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if ("1".equals(this.roleService.checkRoleKeyUnique(role))) {
            return this.error("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u6743\u9650\u5df2\u5b58\u5728");
        }
        role.setUpdateBy(this.getLoginName());
        AuthorizationUtils.clearAllCachedAuthorizationInfo();
        return this.toAjax(this.roleService.updateRole(role));
    }

    @GetMapping(value={"/authDataScope/{roleId}"})
    public String authDataScope(@PathVariable(value="roleId") Long roleId, ModelMap mmap) {
        mmap.put((Object)"role", (Object)this.roleService.selectRoleById(roleId));
        return this.prefix + "/dataScope";
    }

    @RequiresPermissions(value={"system:role:edit"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/authDataScope"})
    @ResponseBody
    public AjaxResult authDataScopeSave(SysRole role) {
        this.roleService.checkRoleAllowed(role);
        role.setUpdateBy(this.getLoginName());
        if (this.roleService.authDataScope(role) > 0) {
            this.setSysUser(this.userService.selectUserById(this.getUserId()));
            return this.success();
        }
        return this.error();
    }

    @RequiresPermissions(value={"system:role:remove"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.roleService.deleteRoleByIds(ids));
    }

    @PostMapping(value={"/checkRoleNameUnique"})
    @ResponseBody
    public String checkRoleNameUnique(SysRole role) {
        return this.roleService.checkRoleNameUnique(role);
    }

    @PostMapping(value={"/checkRoleKeyUnique"})
    @ResponseBody
    public String checkRoleKeyUnique(SysRole role) {
        return this.roleService.checkRoleKeyUnique(role);
    }

    @GetMapping(value={"/selectMenuTree"})
    public String selectMenuTree() {
        return this.prefix + "/tree";
    }

    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"system:role:edit"})
    @PostMapping(value={"/changeStatus"})
    @ResponseBody
    public AjaxResult changeStatus(SysRole role) {
        this.roleService.checkRoleAllowed(role);
        return this.toAjax(this.roleService.changeStatus(role));
    }

    @RequiresPermissions(value={"system:role:edit"})
    @GetMapping(value={"/authUser/{roleId}"})
    public String authUser(@PathVariable(value="roleId") Long roleId, ModelMap mmap) {
        mmap.put((Object)"role", (Object)this.roleService.selectRoleById(roleId));
        return this.prefix + "/authUser";
    }

    @RequiresPermissions(value={"system:role:list"})
    @PostMapping(value={"/authUser/allocatedList"})
    @ResponseBody
    public TableDataInfo allocatedList(SysUser user) {
        this.startPage();
        List list = this.userService.selectAllocatedList(user);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"system:role:edit"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PostMapping(value={"/authUser/cancel"})
    @ResponseBody
    public AjaxResult cancelAuthUser(SysUserRole userRole) {
        return this.toAjax(this.roleService.deleteAuthUser(userRole));
    }

    @RequiresPermissions(value={"system:role:edit"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PostMapping(value={"/authUser/cancelAll"})
    @ResponseBody
    public AjaxResult cancelAuthUserAll(Long roleId, String userIds) {
        return this.toAjax(this.roleService.deleteAuthUsers(roleId, userIds));
    }

    @GetMapping(value={"/authUser/selectUser/{roleId}"})
    public String selectUser(@PathVariable(value="roleId") Long roleId, ModelMap mmap) {
        mmap.put((Object)"role", (Object)this.roleService.selectRoleById(roleId));
        return this.prefix + "/selectUser";
    }

    @RequiresPermissions(value={"system:role:list"})
    @PostMapping(value={"/authUser/unallocatedList"})
    @ResponseBody
    public TableDataInfo unallocatedList(SysUser user) {
        this.startPage();
        List list = this.userService.selectUnallocatedList(user);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"system:role:edit"})
    @Log(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PostMapping(value={"/authUser/selectAll"})
    @ResponseBody
    public AjaxResult selectAuthUserAll(Long roleId, String userIds) {
        return this.toAjax(this.roleService.insertAuthUsers(roleId, userIds));
    }
}

