/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.teleMonitor;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.teleMonitor.domain.ConfigProjectGroup;
import com.ruoyi.teleMonitor.service.IConfigProjectGroupService;
import com.ruoyi.teleMonitor.service.IConfigTelegramBotService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/teleMonitor/group"})
public class ConfigProjectGroupController
extends BaseController {
    private String prefix = "teleMonitor/group";
    @Autowired
    private IConfigProjectGroupService configProjectGroupService;
    @Autowired
    private IConfigTelegramBotService configTelegramBotService;

    @GetMapping
    public String group(ModelMap mmap) {
        List configTelegramBots = this.configTelegramBotService.selectConfigTelegramBotList(null);
        mmap.put((Object)"configTelegramBots", (Object)configTelegramBots);
        return this.prefix + "/group";
    }

    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(ConfigProjectGroup configProjectGroup) {
        this.startPage();
        List list = this.configProjectGroupService.selectConfigProjectGroupList(configProjectGroup);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"teleMonitor:group:export"})
    @Log(title="\u9879\u76ee\u7fa4\u7ec4\u914d\u7f6e", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(ConfigProjectGroup configProjectGroup) {
        List list = this.configProjectGroupService.selectConfigProjectGroupList(configProjectGroup);
        ExcelUtil util = new ExcelUtil(ConfigProjectGroup.class);
        return util.exportExcel(list, "\u9879\u76ee\u7fa4\u7ec4\u914d\u7f6e\u6570\u636e");
    }

    @GetMapping(value={"/add"})
    public String add(ModelMap mmap) {
        List configTelegramBots = this.configTelegramBotService.selectConfigTelegramBotList(null);
        mmap.put((Object)"configTelegramBots", (Object)configTelegramBots);
        return this.prefix + "/add";
    }

    @RequiresPermissions(value={"teleMonitor:group:add"})
    @Log(title="\u9879\u76ee\u7fa4\u7ec4\u914d\u7f6e", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(ConfigProjectGroup configProjectGroup) {
        return this.toAjax(this.configProjectGroupService.insertConfigProjectGroup(configProjectGroup));
    }

    @GetMapping(value={"/edit/{projectId}"})
    public String edit(@PathVariable(value="projectId") Long projectId, ModelMap mmap) {
        ConfigProjectGroup configProjectGroup = this.configProjectGroupService.selectConfigProjectGroupByProjectId(projectId);
        List configTelegramBots = this.configTelegramBotService.selectConfigTelegramBotList(null);
        mmap.put((Object)"configTelegramBots", (Object)configTelegramBots);
        mmap.put((Object)"configProjectGroup", (Object)configProjectGroup);
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"teleMonitor:group:edit"})
    @Log(title="\u9879\u76ee\u7fa4\u7ec4\u914d\u7f6e", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(ConfigProjectGroup configProjectGroup) {
        return this.toAjax(this.configProjectGroupService.updateConfigProjectGroup(configProjectGroup));
    }

    @RequiresPermissions(value={"teleMonitor:group:remove"})
    @Log(title="\u9879\u76ee\u7fa4\u7ec4\u914d\u7f6e", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.configProjectGroupService.deleteConfigProjectGroupByProjectIds(ids));
    }
}

