/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.system;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysDictDataService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/dict/data"})
public class SysDictDataController
extends BaseController {
    private String prefix = "system/dict/data";
    @Autowired
    private ISysDictDataService dictDataService;

    @RequiresPermissions(value={"system:dict:view"})
    @GetMapping
    public String dictData() {
        return this.prefix + "/data";
    }

    @PostMapping(value={"/list"})
    @RequiresPermissions(value={"system:dict:list"})
    @ResponseBody
    public TableDataInfo list(SysDictData dictData) {
        this.startPage();
        List list = this.dictDataService.selectDictDataList(dictData);
        return this.getDataTable(list);
    }

    @Log(title="\u5b57\u5178\u6570\u636e", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:dict:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(SysDictData dictData) {
        List list = this.dictDataService.selectDictDataList(dictData);
        ExcelUtil util = new ExcelUtil(SysDictData.class);
        return util.exportExcel(list, "\u5b57\u5178\u6570\u636e");
    }

    @GetMapping(value={"/add/{dictType}"})
    public String add(@PathVariable(value="dictType") String dictType, ModelMap mmap) {
        mmap.put((Object)"dictType", (Object)dictType);
        return this.prefix + "/add";
    }

    @Log(title="\u5b57\u5178\u6570\u636e", businessType=BusinessType.INSERT)
    @RequiresPermissions(value={"system:dict:add"})
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(@Validated SysDictData dict) {
        dict.setCreateBy(this.getLoginName());
        return this.toAjax(this.dictDataService.insertDictData(dict));
    }

    @GetMapping(value={"/edit/{dictCode}"})
    public String edit(@PathVariable(value="dictCode") Long dictCode, ModelMap mmap) {
        mmap.put((Object)"dict", (Object)this.dictDataService.selectDictDataById(dictCode));
        return this.prefix + "/edit";
    }

    @Log(title="\u5b57\u5178\u6570\u636e", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"system:dict:edit"})
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated SysDictData dict) {
        dict.setUpdateBy(this.getLoginName());
        return this.toAjax(this.dictDataService.updateDictData(dict));
    }

    @Log(title="\u5b57\u5178\u6570\u636e", businessType=BusinessType.DELETE)
    @RequiresPermissions(value={"system:dict:remove"})
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        this.dictDataService.deleteDictDataByIds(ids);
        return this.success();
    }
}

