/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.system;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.text.Convert;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.ShiroUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.shiro.service.SysPasswordService;
import com.ruoyi.system.service.ISysPostService;
import com.ruoyi.system.service.ISysRoleService;
import com.ruoyi.system.service.ISysUserService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/system/user"})
public class SysUserController
extends BaseController {
    private String prefix = "system/user";
    @Autowired
    private ISysUserService userService;
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysPostService postService;
    @Autowired
    private SysPasswordService passwordService;

    @RequiresPermissions(value={"system:user:view"})
    @GetMapping
    public String user() {
        return this.prefix + "/user";
    }

    @RequiresPermissions(value={"system:user:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(SysUser user) {
        this.startPage();
        List list = this.userService.selectUserList(user);
        return this.getDataTable(list);
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:user:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(SysUser user) {
        List list = this.userService.selectUserList(user);
        ExcelUtil util = new ExcelUtil(SysUser.class);
        return util.exportExcel(list, "\u7528\u6237\u6570\u636e");
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.IMPORT)
    @RequiresPermissions(value={"system:user:import"})
    @PostMapping(value={"/importData"})
    @ResponseBody
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtil util = new ExcelUtil(SysUser.class);
        List userList = util.importExcel(file.getInputStream());
        String message = this.userService.importUser(userList, Boolean.valueOf(updateSupport), this.getLoginName());
        return AjaxResult.success((String)message);
    }

    @RequiresPermissions(value={"system:user:view"})
    @GetMapping(value={"/importTemplate"})
    @ResponseBody
    public AjaxResult importTemplate() {
        ExcelUtil util = new ExcelUtil(SysUser.class);
        return util.importTemplateExcel("\u7528\u6237\u6570\u636e");
    }

    @GetMapping(value={"/add"})
    public String add(ModelMap mmap) {
        mmap.put((Object)"roles", this.roleService.selectRoleAll().stream().filter(r -> !r.isAdmin()).collect(Collectors.toList()));
        mmap.put((Object)"posts", (Object)this.postService.selectPostAll());
        return this.prefix + "/add";
    }

    @RequiresPermissions(value={"system:user:add"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(@Validated SysUser user) {
        if ("1".equals(this.userService.checkLoginNameUnique(user.getLoginName()))) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getLoginName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getPhonenumber()) && "1".equals(this.userService.checkPhoneUnique(user))) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getLoginName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getEmail()) && "1".equals(this.userService.checkEmailUnique(user))) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getLoginName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        user.setSalt(ShiroUtils.randomSalt());
        user.setPassword(this.passwordService.encryptPassword(user.getLoginName(), user.getPassword(), user.getSalt()));
        user.setCreateBy(this.getLoginName());
        return this.toAjax(this.userService.insertUser(user));
    }

    @GetMapping(value={"/edit/{userId}"})
    public String edit(@PathVariable(value="userId") Long userId, ModelMap mmap) {
        List roles = this.roleService.selectRolesByUserId(userId);
        mmap.put((Object)"user", (Object)this.userService.selectUserById(userId));
        mmap.put((Object)"roles", (Object)(SysUser.isAdmin((Long)userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList())));
        mmap.put((Object)"posts", (Object)this.postService.selectPostsByUserId(userId));
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"system:user:edit"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated SysUser user) {
        this.userService.checkUserAllowed(user);
        if (StringUtils.isNotEmpty((String)user.getPhonenumber()) && "1".equals(this.userService.checkPhoneUnique(user))) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getLoginName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getEmail()) && "1".equals(this.userService.checkEmailUnique(user))) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getLoginName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        user.setUpdateBy(this.getLoginName());
        return this.toAjax(this.userService.updateUser(user));
    }

    @RequiresPermissions(value={"system:user:resetPwd"})
    @GetMapping(value={"/resetPwd/{userId}"})
    public String resetPwd(@PathVariable(value="userId") Long userId, ModelMap mmap) {
        mmap.put((Object)"user", (Object)this.userService.selectUserById(userId));
        return this.prefix + "/resetPwd";
    }

    @RequiresPermissions(value={"system:user:resetPwd"})
    @Log(title="\u91cd\u7f6e\u5bc6\u7801", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/resetPwd"})
    @ResponseBody
    public AjaxResult resetPwdSave(SysUser user) {
        this.userService.checkUserAllowed(user);
        user.setSalt(ShiroUtils.randomSalt());
        user.setPassword(this.passwordService.encryptPassword(user.getLoginName(), user.getPassword(), user.getSalt()));
        if (this.userService.resetUserPwd(user) > 0) {
            if (ShiroUtils.getUserId().longValue() == user.getUserId().longValue()) {
                this.setSysUser(this.userService.selectUserById(user.getUserId()));
            }
            return this.success();
        }
        return this.error();
    }

    @GetMapping(value={"/authRole/{userId}"})
    public String authRole(@PathVariable(value="userId") Long userId, ModelMap mmap) {
        SysUser user = this.userService.selectUserById(userId);
        List roles = this.roleService.selectRolesByUserId(userId);
        mmap.put((Object)"user", (Object)user);
        mmap.put((Object)"roles", (Object)(SysUser.isAdmin((Long)userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList())));
        return this.prefix + "/authRole";
    }

    @RequiresPermissions(value={"system:user:edit"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PostMapping(value={"/authRole/insertAuthRole"})
    @ResponseBody
    public AjaxResult insertAuthRole(Long userId, Long[] roleIds) {
        this.userService.insertUserAuth(userId, roleIds);
        return this.success();
    }

    @RequiresPermissions(value={"system:user:remove"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        if (ArrayUtils.contains((Object[])Convert.toLongArray((String)ids), (Object)this.getUserId())) {
            return this.error("\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u5220\u9664");
        }
        return this.toAjax(this.userService.deleteUserByIds(ids));
    }

    @PostMapping(value={"/checkLoginNameUnique"})
    @ResponseBody
    public String checkLoginNameUnique(SysUser user) {
        return this.userService.checkLoginNameUnique(user.getLoginName());
    }

    @PostMapping(value={"/checkPhoneUnique"})
    @ResponseBody
    public String checkPhoneUnique(SysUser user) {
        return this.userService.checkPhoneUnique(user);
    }

    @PostMapping(value={"/checkEmailUnique"})
    @ResponseBody
    public String checkEmailUnique(SysUser user) {
        return this.userService.checkEmailUnique(user);
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"system:user:edit"})
    @PostMapping(value={"/changeStatus"})
    @ResponseBody
    public AjaxResult changeStatus(SysUser user) {
        this.userService.checkUserAllowed(user);
        return this.toAjax(this.userService.changeStatus(user));
    }
}

